##
## RMeCab 0.59  by ishida.motohiro@gmail.com  # 2008 08 23
##

######### # 記号から右の記述はコメントです。
#########　#　記号を先頭に含む行を範囲指定して実行しても無視されます。

## Linux ユーザのためのインストール方法
## install.packages("RMeCab_0.59.tar.gz", destdir=".",  repos = NULL)


# MacOS X  あるいは Linux ならR のメニューから[ファイル][文書の読み込み]で RMeCab.R を開く
### 以下、ユーザのホームフォルダに　data2　フォルダごとコピーしたものと仮定します

#

################# このスクリプトの使い方
# Windows  なら R のメニューから[ファイル][スクリプトを開く]で RMeCab.R を開く
### 以下、Cドライブに　data　フォルダごとコピーしたものと仮定します


#
################## 「RMeCabの操作方法」
# 

######## パッケージの読み込み
#
 library(RMeCab)
# 上の一行を実行する代わりに 
# メニューの [パッケージ] - [パッケージの読み込み] でもよい

# 作業ディレクトリを指定
# data2.tar.gz を解凍して作成されたディレクトリdata2のフルパスを指定します

# setwd("C:/data") # Windows
# setwd("/Users/*YourAccount*/data2") # Mac OS X/Linux

setwd("/home/ishida/tmp/data2")


#####################################################################
#
#    コードに日本語が含まれる場合，コード全体を範囲指定して実行します!!
#
#####################################################################

#　テスト 1 # RMeCabC () 関数 # 入力文の解析

kekka <- RMeCabC("すもももももももものうち")
unlist(kekka)

# こんな結果
#    名詞     助詞     名詞     助詞     名詞     助詞     名詞 
#"すもも"     "も"   "もも"     "も"   "もも"     "の"   "うち" 


###########################################
#　テスト 2 # RMeCabC () 関数 
# 第二引数 1 を加えると形態素原型を返します．

kekka <- RMeCabC("ご飯を食べた",1)
unlist(kekka)

#    名詞     助詞     動詞   助動詞 
#  "ご飯"     "を" "食べる"     "た" 
#
#　第二引数を加えない場合
#

kekka <- RMeCabC("ご飯を食べた")
unlist(kekka)

#    名詞     助詞     動詞   助動詞


###########################################
#　テスト 3 # RMeCabC () 関数
# 上記の結果から名詞だけ取り出したければ

unlist(kekka) [names(unlist(kekka)) == "名詞"]

# ご飯

###########################################
# テスト4 # RMeCabC () 関数 # 少し長い文章 (120 文字) を解析
### 若干時間がかかります

kekka <- RMeCabC("皇居のお堀を淡いピンクで染めるソメイヨシノの並木は、仕事帰りのOLやサラリーマンに人気のお花見スポット。昼はボートに乗ってお花見を楽しめ、夜はライトアップされロマンチックな雰囲気だ。緑道から眺める石垣と可憐な桜の対比がなんともいえず美しい。")

unlist(kekka)



###########################################
#　テスト5 # RMeCabText()関数 # 引数で指定されたファイルを解析し，結果をそのまま表示する
#　ホームディレクトリに、添付の data フォルダを丸ごとコピーしてから

# targetText <- "C:/data/yukiguni.txt"
# targetText <- "/Users/*YourAccount*/data/yukiguni.txt"

targetText <- "yukiguni.txt"
kekka <- RMeCabText( targetText  )
kekka

# こんな結果
## 		 [[1]]
## 		  [1] "国境"       "名詞"       "一般"       "*"          "*"
## 		  [6] "*"          "*"          "国境"       "コッキョウ" "コッキョー"
## 		 [[2]]
## 		  [1] "の"     "助詞"   "格助詞" "一般"   "*"      "*"      "*"      "の"
## 		  [9] "ノ"     "ノ"
## 		 [[3]]
## 		  [1] "長い"             "形容詞"           "自立"             "*"
## 		  [5] "*"                "形容詞・アウオ段" "基本形"           "長い"         
## 		 # ... 以下略    



## ###########################################
#　テスト 6 #　RMeCabFreq()関数 # ファイルから頻度表を作成 
# targetText <- "C:/data/yukiguni.txt"
# targetText <- "/Users/*YourAccount*/data/yukiguni.txt"

targetText <- "yukiguni.txt"
kekka <- RMeCabFreq(  targetText  )
kekka

# こんな結果
## length = 23 
##        Term  Info1    Info2 Freq
## 1      ある 助動詞        *    1
## 2        た 助動詞        *    3
## 3        だ 助動詞        *    1
## 4        と   助詞 接続助詞    1
## 5        が   助詞   格助詞    2
## 6        に   助詞   格助詞    1
## 7        の   助詞   格助詞    1
## 8        を   助詞   格助詞    1
## 9        の   助詞   連体化    1
## 10     なる   動詞     自立    1
## 11   抜ける   動詞     自立    1
## 12   止まる   動詞     自立    1
## 13 トンネル   名詞     一般    1
## 14     信号   名詞     一般    1
## 15     国境   名詞     一般    1
## 16       底   名詞     一般    1
## 17     汽車   名詞     一般    1
## 18     雪国   名詞     一般    1
## 19       夜   名詞 副詞可能    1
## 20       所   名詞     接尾    1
## 21     白い 形容詞     自立    1
## 22     長い 形容詞     自立    1
## 23       。   記号     句点    3
## > 



###########################################
#　テスト 7 ## ちょっと時間がかかります
#        芥川龍之介　『蜘蛛の糸』(青空文庫から借用)
#        ただし主人公の名前の「かん陀多」の
#        「かん」にあたる漢字は特殊文字なので削っている

#　実行時間を計る
# targetText <- "C:/data/kumo.txt"
# targetText <- "/Users/*YourAccount*/data/kumo.txt"

targetText <- "kumo.txt"

pt1 <- proc.time()
kekka <- RMeCabFreq(targetText )
pt2 <- proc.time()

#　実行時間を見る

pt2 - pt1

# 解析結果を見る

kekka


# 頻度表をグラフにしてみる
# 『蜘蛛の糸』から、一般名詞かつ頻度が　７　以上の語を選ぶ

kekka <- kekka [kekka[, 2] == "名詞" & kekka[, 3] == "一般" & kekka[,4] > 6, ] 

matplot(1:length(kekka$Term), kekka[,4], type = "n")
for(i in 1:length(kekka$Term)){
	matlines(i, kekka[i,4], type = "h", col = i, lwd =5)
}
legend(1, max(kekka$Freq), legend = kekka$Term, col = 1:15, lwd = 5)


# なお　Windows　版の MeCab辞書　では「なんとも云えない」を
############
# #  なんとも        副詞,一般,*,*,*,*,なんとも,ナントモ,ナントモ
# # 云      名詞,一般,*,*,*,*,云,ウン,ウン
# # え      フィラー,*,*,*,*,*,え,エ,エ
# # ない    形容詞,自立,*,*,形容詞・アウオ段,基本形,ない,ナイ,ナイ
############
# のように「え」を「フィラー」とみなしてしまうようです
# 別途辞書をコンパイルする必要があるMac/Linuxでは「云え」動詞と
# 正しく解析します

#########  辞書の作成方法は石田基広著「Rによる日本語テキストマイニング」(仮題)か
### http://mecab.sourceforge.net/dic.html を参照されたい


### 太宰治　『走れメロス』# 青空文庫から転用
# targetText <- "C:/data/merosu.txt"
# targetText <- "/Users/*YourAccount*/data/merosu.txt"
targetText <- "merosu.txt"

pt1 <- proc.time()
kekka <- RMeCabFreq( targetText )
pt2 <- proc.time()

#　実行時間を見る

pt2 - pt1

# 解析結果は長いので、名詞の一部だけを見る

kekka[kekka$Info1 == "名詞" & kekka$Info2 == "一般", ]

# こんな結果##                  Term Info1 Info2 Freq
## 627            あたり  名詞  一般    1
## 628              あて  名詞  一般    1
## 629                い  名詞  一般    1
## 630            いちど  名詞  一般    1
## 631            いのち  名詞  一般    3





###########################################
#　テスト 8 ## * RMeCabDF()関数 # データフレームの指定列を解析 
# targetText <- "C:/data/photo.csv"
# targetText <- "/Users/*YourAccount*/data/photo.csv"

targetText <- "photo.csv"

dat <- read.csv(targetText, head = T)

# 男性の被験者だけを見る
dat[dat$Sex == "M",]

# datという読み込んだデータの 3 列目に日本語がある
# とすると， 3 列目のデータをすべて形態素解析にかけます．

RMeCabDF(dat, 3)
# RMeCabDF(dat, "Reply") # 列名を指定してもよい
## こんな結果
# [[1]]
#  名詞   動詞   助詞   動詞   助詞 
# "写真" "撮っ"   "て" "くれ"   "よ" 
#
# [[2]]
#      名詞       動詞       助詞       動詞 
#    "写真"     "とっ"       "て" "ください" 
# また

RMeCabDF(dat, 3, 1)
# RMeCabDF(dat, "Reply", 1) # 列名を指定してもよい

# とすると，形態素原型を返します．




#########################
##################
#　テスト 9 # docMatrix() 関数 # 文書ターム行列の作成
# 抽出する品詞はpos引数で指定できる

#　Cドライブに添付の data フォルダを丸ごとコピーしてから
# targetDir <- "C:/data/doc"
# targetDir <- "/Users/*YourAccount*/data/doc"

targetDir <- "doc"


##### !!!注意!!!
######  コードに日本語が含まれる場合，行全体を範囲指定して実行する必要があります

res <- docMatrix(targetDir, pos = c("名詞","形容詞","助詞"))

## Reading file doc/doc1.txt
## Reading file doc/doc2.txt
## Reading file doc/doc3.txt
## Term Document Matrix includes 2 information rows! 
## whose names are [[LESS-THAN-1]] and [[TOTAL-TOKENS]]
## if you remove these rows, run
## result[ row.names(result) !=  "[[LESS-THAN-1]]" , ]
## result[ row.names(result) !=  "[[TOTAL-TOKENS]]" , ]
# こんな結果

res

##                   docs
## terms              doc1.txt doc2.txt doc3.txt
##   [[LESS-THAN-1]]         0        0        0
##   [[TOTAL-TOKENS]]        4        6        8
##   は                      1        1        1
##   学生                    1        1        0
##   私                      1        0        0
##   の                      0        1        0
##   数学                    0        1        1
##   彼女                    0        1        1
##   で                      0        0        1
##   を                      0        0        1


# なお出力には，行列の情報を表す行が含まれているので，削除するには次のようにする
res <- res[ row.names(res) !=  "[[LESS-THAN-1]]" , ]
res <- res[ row.names(res) !=  "[[TOTAL-TOKENS]]" , ]
res

##       docs
## terms  doc1.txt doc2.txt doc3.txt
##   は          1        1        1
##   学生        1        1        0
##   私          1        0        0
##   の          0        1        0
##   数学        0        1        1
##   彼女        0        1        1
##   で          0        0        1
##   を          0        0        1



###########################################
#　テスト 10 ## 文書ターム行列の作成　重みをつける １
## (TF-IDF) 詳細は　石田　基広　著『Rによるテキストマイニング入門』森北出版
# 抽出する品詞はpos引数で指定できる

res <- docMatrix(targetDir, pos = c("名詞","形容詞"), weight = "tf*idf") 
res

# こんな結果
## Reading file doc/doc1.txt
## Reading file doc/doc2.txt
## Reading file doc/doc3.txt
##       docs
## terms  doc1.txt doc2.txt doc3.txt
##   学生 1.584963 1.584963 0.000000
##   私   2.584963 0.000000 0.000000
##   数学 0.000000 1.584963 1.584963
##   彼女 0.000000 1.584963 1.584963

###########################################
#　テスト 11 ## 文書ターム行列の作成　重みをつける ２
## (TF-IDF正規化) 詳細は　石田　基広　著『Rによるテキストマイニング入門』森北出版


res <- docMatrix(targetDir, pos = c("名詞","形容詞"),  weight = "tf*idf*norm")
res

# こんな結果
## Reading file doc/doc1.txt
## Reading file doc/doc2.txt
## Reading file doc/doc3.txt
##       docs
## terms   doc1.txt  doc2.txt  doc3.txt
##   学生 0.5227132 0.5773503 0.0000000
##   私   0.8525086 0.0000000 0.0000000
##   数学 0.0000000 0.5773503 0.7071068
##   彼女 0.0000000 0.5773503 0.7071068


## 別の例

targetDir <- "morikita"

## 森北出版のホームページから借用http://www.morikita.co.jp/

res <- docMatrix(targetDir, pos = c("名詞","形容詞"))
res <- res[ row.names(res) !=  "[[LESS-THAN-1]]" , ]
res <- res[ row.names(res) !=  "[[TOTAL-TOKENS]]" , ]
res

## 抽出するタームの最低頻度を指定するには次のようにする

res <-  docMatrix(targetDir, pos = c("名詞","形容詞"))
res <- res[ row.names(res) !=  "[[LESS-THAN-1]]" , ]
res <- res[ row.names(res) !=  "[[TOTAL-TOKENS]]" , ]

res <- res[rowSums(res) > 1,]  # 全体を通して2回以上出現したタームのみ解析対象とする
res
##         docs
## terms    morikita1.txt morikita2.txt morikita3.txt
##   家                 1             1             0
##   学                 1             0             2
##   系                 1             0             1
##   研究               1             1             1
##   者                 1             5             2
##   出版               2             0             1
##   小社               1             0             1
##   専門               2             0             1
##   方々               1             1             0
##   理工               1             0             2
##   技術               0             1             1
##   著者               0             2             0
##   編集               0             2             0
##   皆さん             0             0             2
##   書籍               0             0             2




## 次のコマンドは各文書ごとに指定した頻度以下のタームを省く処理である．
## 直前の処理とは意味が違うので注意されたい

res <- docMatrix(targetDir, pos = c("名詞","形容詞"), minFreq = 3) 
res
##                  docs
## terms              morikita1.txt morikita2.txt morikita3.txt
##   [[LESS-THAN-3]]             22            23            31
##   [[TOTAL-TOKENS]]            42            60            77
##   者                           0             5             0



## 句読点などの記号を総頻度に含める場合
# targetDir <- "/Users/*YourAccount*/data/doc"

targetDir <- "doc"

# コードに日本語が含まれる場合，行全体を範囲指定して実行する必要があります

res <- docMatrix(targetDir, pos = c("名詞","形容詞"), sym = 1)
res

##                   docs
## terms              doc1.txt doc2.txt doc3.txt
##   [[LESS-THAN-1]]         0        0        0
##   [[TOTAL-TOKENS]]        5        7        9
##   学生                    1        1        0
##   私                      1        0        0
##   数学                    0        1        1
##   彼女                    0        1        1


##下の出力と比較して下さい．

res <- docMatrix(targetDir, pos = c("名詞","形容詞"))
res

##                   docs
## terms              doc1.txt doc2.txt doc3.txt
##   [[LESS-THAN-1]]         0        0        0
##   [[TOTAL-TOKENS]]        4        6        8   ### 総頻度が変わっている
##   学生                    1        1        0
##   私                      1        0        0
##   数学                    0        1        1
##   彼女                    0        1        1

## なおpos に記号を含めると，自動的に記号の頻度を含めた総頻度が出力されます．

res <- docMatrix(targetDir, pos = c("名詞","形容詞","記号"))
res

##                   docs
## terms              doc1.txt doc2.txt doc3.txt
##   [[LESS-THAN-1]]         0        0        0
##   [[TOTAL-TOKENS]]        5        7        9
##   ．                      1        1        1
##   学生                    1        1        0
##   私                      1        0        0
##   数学                    0        1        1
##   彼女                    0        1        1






###########################################
#　テスト 12  # Ngram()関数  :引数で指定されたファイルについて，
# N-gram を計る．引数 type が 0 なら文字単位で，1 なら形態素原形を単位として，
# また 2 なら品詞情報を単位に N-gram をカウントする．なお N は引数 N で指定．
# targetText <- "/Users/*YourAccount*/data/doc"
# targetText <- "C:/data/doc"

targetText <- "kumo.txt"
res <- Ngram(targetText, type = 0, N = 2) # 文字単位　2-gram
nrow(res)
res[1:100,]


## # こんな結果
##       Ngram Freq
## 1   [、-「]    3
## 2   [、-あ]    1
## 3   [、-い]    4
## 4   [、-う]    2
## 5   [、-き]    2

res <- Ngram(targetText, type = 1, N = 3) # 形態素単位　3-gram
nrow(res)
res[1:100,] # 長いので一部だけ確認

# こんな結果
##                    Ngram Freq
## 1           [、-「-いや]    1
## 2           [、-「-こら]    1
## 3         [、-「-しめる]    1
## 4           [、-ある-時]    1
## 5         [、-いくら-何]    1

res <- Ngram( targetText, type = 2, N = 3) # 品詞単位 3-gram
nrow(res)
res[1:100,]

# こんな結果
##                      Ngram Freq
## 1     [フィラー-副詞-動詞]    1
## 2         [副詞-副詞-動詞]    1
## 3         [副詞-副詞-名詞]    1
## 4         [副詞-助詞-動詞]    4
## 5         [副詞-助詞-名詞]    2


# 形態素 type = 1 を指定した場合は，品詞を指定して N-gram を抽出することができる．

res <- Ngram("yukiguni.txt", type = 1, N = 2, pos = "名詞")
res

# こんな結果
## 		             Ngram Freq
## 		 1 [トンネル-雪国]    1
## 		 2       [信号-所]    1
## 		 3 [国境-トンネル]    1
## 		 4         [夜-底]    1
## 		 5       [底-信号]    1
## 		 6       [所-汽車]    1
## 		 7       [雪国-夜]    1



###########################################
#　テスト 13  # NgramDF()関数 
### Ngram() 関数とほぼ等価だが
#### ただし出力はN-gramの要素ごとに列を分けたデータフレーム

resDF <- NgramDF("yukiguni.txt", type = 1, N = 2,   pos = "名詞")
resDF

## # こんな結果
## 		     Ngram1   Ngram2 Freq
## 		 1 トンネル     雪国    1
## 		 2     信号       所    1
## 		 3     国境 トンネル    1
## 		 4       夜       底    1
## 		 5       底     信号    1
## 		 6       所     汽車    1
## 		 7     雪国       夜    1




###########################################
#　テスト 14  #  docNgram()関数  :引数で指定したフォルダを指定し，そのフォルダ内のすべてのファイルを解析対象としてターム・文書行列を作成するなお，この関数でも引数 \verb|type| と \verb|N| を \verb|Ngram()| 関数の場合と同じように指定することができる．以下では \verb|data| フォルダ内にある \verb|doc| フォルダに含まれた全ファイルを対象に解析する．

res <- docNgram("doc") # デフォルトは形態素単位の2-gram
res

## # こんな結果
##              Text
## Ngram         doc1.txt doc2.txt doc3.txt
##   [私-学生]          1        0        0
##   [数学-学生]        0        1        0
##   [彼女-数学]        0        1        1


res <- docNgram("doc", type = 0) # 文字単位に変更
res

## 		          Text
## 		 Ngram     doc1.txt doc2.txt doc3.txt
## 		   [い-ま]        0        0        1
## 		   [で-い]        0        0        1
## 		   [の-学]        0        1        0
## 		# 以下略


###########################################
##### docMatrixDF() 関数
##### データフレームから文書・ターム行列を作成する


# targetText <- "/Users/*YourAccount*/data/photo.csv"

targetText <- "photo.csv"

dat <- read.csv(targetText, head = T)
colnames(dat)

# 男性の被験者だけを見る
dat[dat$Sex == "M",]

res <- docMatrixDF(dat[,"Reply"])
res
##          OBS.1 OBS.2 OBS.3 OBS.4 OBS.5
## くださる     0     1     0     1     0
## くれる       1     0     0     0     0
## とる         1     1     1     1     1
## 写真         1     1     1     1     1
### テキスト（被験者）全体を通じて，総頻度が ２ 以上のタームを抽出
## ここで総頻度とは、各タームごとに、各文書での出現した頻度を合計した頻度をいう


res <- docMatrixDF(dat[,"Reply"], minFreq = 2)
res

##          OBS.1 OBS.2 OBS.3 OBS.4 OBS.5
## くださる     0     1     0     1     0
## とる         1     1     1     1     1
## 写真         1     1     1     1     1



###########################################
#　# collocate()関数  : 指定されたファイルについて，
# word で指定された語(ただし形態素原形)の前後に出てくる単語頻度を計算する．
# なおスパンは引数 span で指定する．
# setwd("/Users/*YourAccount*/data2") # MacOS X/Linux

targetText = "kumo.txt"
res <- collocate(file = targetText, node = "極楽", span = 3)
 # length = 31
res

## # こんな結果

##            Term Span Total
## 1            、    2   136
## 2            。    4    61
## 3            う    1     9
## 4            が    1    34
## 5          この    1    11
## 6        しかし    2     2


###########################################
#　テスト 16  # colloScores()関数
# collocate() 関数の出力であるオブジェクト を第 1 引数として，collocate() 関数で指定した中心語を node 引数に，同じく span に前後の語数を指定する．

res2 <- collScores(res, node = "極楽", span = 3)

 res2
## ## # こんな結果
##            Term Span Total          T         MI
## 1            、    2   136 -1.7771533 -1.1741745
## 2            。    4    61  0.9878319  0.9825510
## 3            う    1     9  0.7013274  1.7433634
## 4            が    1    34 -0.1283186 -0.1741745
## 5          この    1    11  0.6349558  1.4538567


######################
#####　2008年8月追加の関数類

##### docMatrix2()関数
#################### docMatrix()関数の拡張版
## 第 1 引数で指定されたファイル (フォルダが指定された場合は，その中の全ファイル)
## を読み込んで，ターム・文書行列を作成する．
## なお[[LESS-THAN-1]] と [[TOTAL-TOKENS]] の情報行は追加されない 
## 
##   指定可能な引数は
##      directory, pos, minFreq, sym, weight  である．
## directory 引数はファイル名ないしフォルダ名であり
##              (どちらが指定されたかは自動判定される)
## pos 引数は pos = c(``名詞'', ``形容詞'') のように指定する
## minFreq 引数には頻度の閾値を指定するが，docMatrix() 関数の場合とは異なり，
##     全テキストを通じての総頻度を判定対象とする．
##            例えば minFreq=2 と指定した場合，どれか一つの文書で頻度が二つ以上
##            のタームは，これ以外の各文書に一度しか出現していなくとも，
##            出力のターム・文書行列に含まれる． 
##            docMatrix() 関数では，文書のごとの最低頻度であった．
##            したがって，doc1という文書で二度以上出現しているタームが，
##            他の文書で一度しか出現していない場合，このタームは出力の
##            ターム．文書行列に含まれるが，doc1以外の文書の頻度は一律 0 にされる
## sym 引数は，抽出タームに句読点なので記号を含めるかを指定する．
##            デフォルトでは sym = 0 とセットされており，
##            記号はカウントされないが，
##            sym = 1 とすると，記号を含めてカウントした結果が出力される
##            pos 引数に記号が含まれた場合は自動的に sym = 1 とセットされる．

# # setwd("/Users/*YourAccount*/data2") # MacOS X/Linux
targetDir <- "doc"

res <- docMatrix2("doc")# doc フォルダを指定
		# res <- docMatrix2("doc", pos = c("名詞","形容詞"),
		#    minFreq = 1, sym = 0, weight = "no") に同じ
res
##      doc1.txt doc2.txt doc3.txt
## 学生        1        1        0
## 私          1        0        0
## 数学        0        1        1
## 彼女        0        1        1


# コードに日本語が含まれる場合，行全体を範囲指定して実行する必要があります

res <- docMatrix2(targetDir, pos = c("名詞","形容詞"),weight = "tf*idf*norm")
res 
# > res 
#      doc1.txt  doc2.txt  doc3.txt
# 学生 0.5227132 0.5773503 0.0000000
# 私   0.8525086 0.0000000 0.0000000
# 数学 0.0000000 0.5773503 0.7071068
# 彼女 0.0000000 0.5773503 0.7071068

res <- docMatrix2(targetDir, pos = c("名詞","形容詞","記号" ))#記号を含める
res
##      doc1.txt doc2.txt doc3.txt
## 学生        1        1        0
## 彼女        0        1        1
## 数学        0        1        1
## 私          1        0        0
## ．          1        1        1


## 単独ファイルの処理も可能
res <- docMatrix2("morikita/morikita1.txt", pos = c("名詞","形容詞","記号" ))#記号を含める
res
##        morikita1.txt
## 、                 2
## 。                 2
## こと               1
## 世の中             1
## 使命               1
## 出版               2
## 分野               1
## 化                 1
## 国内               1
## 学                 1


#####################
#####　2008年8月追加の関数類

##### docNgram2()関数
#################### docNgram()関数の拡張版
## 
##   指定可能な引数は
##      directory, type, pos, minFreq, N, sym   である．
## directory 引数はファイル名ないしフォルダ名であり
##              (どちらが指定されたかは自動判定される)
## type 引数は　type=0　が文字、type=1　が形態素、type=2　が記号である
## pos 引数は pos = c(``名詞'', ``形容詞'') のように指定する
##       type引数指定が文字 0 あるいは記号 1 の場合は無視される
## minFreq 引数には頻度の閾値を指定するが，docMatrix() 関数の場合とは異なり，
##     全テキストを通じての総頻度を判定対象とする．
##            例えば minFreq=2 と指定した場合，どれか一つの文書で頻度が二つ以上
##            のタームは，これ以外の各文書に一度しか出現していなくとも，
##            出力のターム・文書行列に含まれる． 
##            docMatrix() 関数では，文書のごとの最低頻度であった．
##            したがって，doc1という文書で二度以上出現しているタームが，
##            他の文書で一度しか出現していない場合，このタームは出力の
##            ターム．文書行列に含まれるが，doc1以外の文書の頻度は一律 0 にされる
## N 引数は N-gram　を指定する。上限は設定されていないが、あまり大きな数値を指定すると
##      R の処理能力の限界を超えるので注意されたい
## sym 引数は，抽出タームに句読点なので記号を含めるかを指定する．
##            デフォルトでは sym = 0 とセットされており，
##            記号はカウントされないが，
##            sym = 1 とすると，記号を含めてカウントした結果が出力される
##            pos 引数に記号が含まれた場合は自動的に sym = 1 とセットされる．
# setwd("/Users/*YourAccount*/data2") # MacOS X/Linux

targetDir <- "doc"

res <- docNgram2(targetDir, pos = c("名詞","形容詞") )
res # デフォルトは文字の2-gram

#         doc1.txt doc2.txt doc3.txt
# [い-ま]        0        0        1
# [す-．]        1        1        1
# [で-い]        0        0        1
# [で-す]        1        1        0
## ...

res <- docNgram2(targetDir, type = 1, pos = c("名詞","形容詞") )
res # 形態素、記号を含まず

#             doc1.txt doc2.txt doc3.txt
# [私-学生]          1        0        0
# [数学-学生]        0        1        0
# [彼女-数学]        0        1        1


res <- docNgram2(targetDir, type = 1, pos = c("名詞","形容詞","記号") )
res # 形態素、記号を含む

#             doc1.txt doc2.txt doc3.txt
# [学生-．]          1        1        0
# [私-学生]          1        0        0
# [数学-．]          0        0        1
# [数学-学生]        0        1        0


res <- docNgram2(targetDir, type = 2)
res

#               doc1.txt doc2.txt doc3.txt
# [助詞-動詞]          0        0        1
# [助詞-名詞]          1        1        1
# [助動詞-記号]        1        1        1
# [動詞-助詞]          0        0        1
# [動詞-助動詞]        0        0        1
# [名詞-助詞]          1        1        1
# [名詞-助動詞]        1        1        0

res <- docNgram2(targetDir, type = 2, N = 5)
res

#                              doc1.txt doc2.txt doc3.txt
# [助詞-動詞-助詞-動詞-助動詞]        0        0        1
# [助詞-名詞-助詞-動詞-助詞]          0        0        1
# [助詞-名詞-助詞-名詞-助動詞]        0        1        0
# [動詞-助詞-動詞-助動詞-記号]        0        0        1
# [名詞-助詞-動詞-助詞-動詞]          0        0        1
# [名詞-助詞-名詞-助詞-動詞]          0        0        1
# [名詞-助詞-名詞-助詞-名詞]          0        1        0
# [名詞-助詞-名詞-助動詞-記号]        1        1        0

res <- docNgram2(targetDir, type = 2, minFreq =2, N = 5) # 文書全体での総頻度を指定
res
#                             doc1.txt doc2.txt doc3.txt
# [名詞-助詞-名詞-助動詞-記号]        1        1        0


## 単独ファイルの処理も可能
res <- docNgram2("morikita/morikita1.txt", pos = c("名詞","形容詞","記号" ))#記号を含める
res
##        morikita1.txt
## [、-伝]             1
## [、-国]             1
## [。-小]             1
## [々-の]             1
## [い-ま]             1
## [え-る]             1
## [こ-と]             1
## [し-、]             1
## [し-た]             1
## [し-て]             1
## [す-。]             2


#####################
#####　2008年8月追加の関数類

##### NgramDF2()関数
#################### NgramDF()関数の拡張版
## 
##   指定可能な引数は
##      directory, type, pos, minFreq, N, sym   である．
## directory 引数はファイル名ないしフォルダ名であり
##              (どちらが指定されたかは自動判定される)
## type 引数は　type=0　が文字、type=1　が形態素、type=2　が記号である
## pos 引数は pos = c(``名詞'', ``形容詞'') のように指定する
##       type引数指定が文字 0 あるいは記号 1 の場合は無視される
## minFreq 引数には頻度の閾値を指定するが，docMatrix() 関数の場合とは異なり，
##     全テキストを通じての総頻度を判定対象とする．
##            例えば minFreq=2 と指定した場合，どれか一つの文書で頻度が二つ以上
##            のタームは，これ以外の各文書に一度しか出現していなくとも，
##            出力のターム・文書行列に含まれる． 
##            docMatrix() 関数では，文書のごとの最低頻度であった．
##            したがって，doc1という文書で二度以上出現しているタームが，
##            他の文書で一度しか出現していない場合，このタームは出力の
##            ターム．文書行列に含まれるが，doc1以外の文書の頻度は一律 0 にされる
## N 引数は N-gram　を指定する。上限は設定されていないが、あまり大きな数値を指定すると
##      R の処理能力の限界を超えるので注意されたい
## sym 引数は，抽出タームに句読点なので記号を含めるかを指定する．
##            デフォルトでは sym = 0 とセットされており，
##            記号はカウントされないが，
##            sym = 1 とすると，記号を含めてカウントした結果が出力される
##            pos 引数に記号が含まれた場合は自動的に sym = 1 とセットされる．
# setwd("/Users/*YourAccount*/data2") # MacOS X/Linux

targetDir <- "doc"

res <- NgramDF2(targetDir) 
res  # デフォルトは type = 0, N = 2
#    Ngram1 Ngram2 doc1.txt doc2.txt doc3.txt
# 1      い     ま        0        0        1
# 2      す     ．        1        1        1
# 3      で     い        0        0        1
# 4      で     す        1        1        0
# 5      の     学        0        1        0
# ...


res <- NgramDF2(targetDir, type = 1, pos = c("名詞","形容詞") )
res
#   Ngram1 Ngram2 doc1.txt doc2.txt doc3.txt
# 1     私   学生        1        0        0
# 2   数学   学生        0        1        0
# 3   彼女   数学        0        1        1


res <- NgramDF2(targetDir, type = 1, pos = c("名詞","形容詞","記号") )
res  # 記号を含める

#   Ngram1 Ngram2 doc1.txt doc2.txt doc3.txt
# 1   学生     ．        1        1        0
# 2     私   学生        1        0        0
# 3   数学     ．        0        0        1
# 4   数学   学生        0        1        0
# 5   彼女   数学        0        1        1


head(res)



res <- NgramDF2(targetDir, type = 2) 
res  # 品詞
#   Ngram1 Ngram2 doc1.txt doc2.txt doc3.txt
# 1   助詞   動詞        0        0        1
# 2   助詞   名詞        1        1        1
# 3 助動詞   記号        1        1        1
# 4   動詞   助詞        0        0        1
# 5   動詞 助動詞        0        0        1
# 6   名詞   助詞        1        1        1
# 7   名詞 助動詞        1        1        0

res <- NgramDF2(targetDir, type = 2, minFreq = 2) 
res  # 品詞で全文書を通じての頻度が 2 以上

#   Ngram1 Ngram2 doc1.txt doc2.txt doc3.txt
# 1   助詞   動詞        0        0        1
# 2   助詞   名詞        1        1        1
# 3 助動詞   記号        1        1        1
# 4   名詞   助詞        1        1        1
# 5   名詞 助動詞        1        1        0

##
## 単独ファイルの処理も可能
res <- NgramDF2("morikita/morikita1.txt", pos = c("名詞","形容詞","記号" ))#記号を含める
res
##    Ngram1 Ngram2 morikita1.txt
## 1      、     伝             1
## 2      、     国             1
## 3      。     小             1
## 4      々     の             1
## 5      い     ま             1
## 6      え     る             1

## targetDir <- "C:/workhome/data/genbun"
## res <- docMatrix2(targetDir, pos ="名詞", minFreq = 2) 
## res <- docNgram2(targetDir, minFreq = 2) 
## res <- NgramDF2(targetDir, type = 2, minFreq = 2) 

## head(res)
