####### RCaBoCha_0.26 for R 2-11.1 スクリプトファイル
#
# ishida.motohiro_at_gmail.com
#
# http://rmecab.jp/
#
###############################################
                                        #　これは UTF-8  ファイルです。
#　Windows ユーザーはこのファイル"RCaBoCha.R"と、付属のファイルすべてを
#　Shift JIS　に変換してください。


setwd("/Users/motohiro/R/dataRCaBoChaUnix")

## インストールはメニューを使って下さい
##   install.packages("RCaBoCha_0.26.tar.gz",    destdir=".",   repos = NULL) 


   library(RCaBoCha)


# 文章を直接入力して解析


#####################################################
#
#
#          RCaBoCha() 関数
#
#
#####################################################
#　CaBoCha　の解析結果をそのまま出力

RCaBoCha("それは面白い本であった。")

## FROMAT_TREE =
##        それは---D
##         面白い-D
##     本であった。
## EOS
##    Term1  Term2    POS D1 D2
## 1   それ   それ   名詞  1  2
## 2     は     は   助詞  1  2
## 3 面白い 面白い 形容詞  2  2
## 4     本     本   名詞  3 -1
## 5     で     だ 助動詞  3 -1
## 6   あっ   ある 助動詞  3 -1
## 7     た     た 助動詞  3 -1
## 8     。     。   記号  3 -1


RCaBoCha("それは面白い本であった。",0)# Tree を出さない

RCaBoCha("それは面白い本であった。",mecabrc="/Users/motohiro/.mecabrc")# mecabrc を指定

#####################################################
#
#
#          RCaBoChaFreq() 関数
#
#
#####################################################
## CaBoCha　の解析結果を頻度表に
#　この際、str2 で指定したタームとの係り受けを考慮．
# 指定されない場合は 否定の「ない」との係り受けを考慮

RCaBoChaFreq("それは面白い本であった。しかし、この本に比べると面白くはない。")

## string 2 = "ない" setted: length = 0 
##           Term           Pos Freq
## 1           、          記号    1
## 2           。          記号    2
## 3         ある        助動詞    1
## 4         この        連体詞    1
## 5       しかし        接続詞    1
## 6         それ          名詞    1
## 7           た        助動詞    1
## 8           だ        助動詞    1
## 9           と          助詞    1
## 10          に          助詞    1
## 11          は          助詞    1
## 12     は+ない   助詞+形容詞    1
## 13          本          名詞    2
## 14      比べる          動詞    1
## 15      面白い        形容詞    1
## 16 面白い+ない 形容詞+形容詞    1
## >

# 係り受けのタームを指定する．デフォルトは「ない」
RCaBoChaFreq("それは面白い本であった。しかし、この本に比べると面白くはない。", str2 = "は")
## string 2 = "は" setted: length = 1 
##         Term         Pos Freq
## 1         、        記号    1
## 2         。        記号    2
## 3       ある      助動詞    1
## 4       この      連体詞    1
## 5     しかし      接続詞    1
## 6    それ+は   名詞+助詞    1
## 7         た      助動詞    1
## 8         だ      助動詞    1
## 9         と        助詞    1
## 10      ない      形容詞    1
## 11        に        助詞    1
## 12        本        名詞    2
## 13    比べる        動詞    1
## 14    面白い      形容詞    1
## 15 面白い+は 形容詞+助詞    1


RCaBoChaFreq("それは面白い本であった。しかし、この本に比べると面白くはない。", str2 = "は",mecabrc="/Users/motohiro/.mecabrc")# mecabrc を指定

#####################################################
#
#
#          RCaBoChaFile() 関数
#
#
#####################################################
#　ファイルを読み込んで頻度表を作成
#　この際、str2 で指定したタームとの係り受けを考慮．
# 指定されない場合は 否定の「ない」との係り受けを考慮
# さらに 引数 rmT =c("記号","助詞") 等として対象としない品詞を指定できます


res  <- RCaBoChaFile("kumo.txt", "")

## Pos[0] =  記号 	removed 
## file = kumo.txt

res

##              Term         Pos Freq
## 1          あたり        名詞    3
## 2            あっ      感動詞    1
## 3            あの    フィラー    1
## 4            ある        動詞   10
## 5            ある      連体詞    3
## 6            あれ        名詞    1
## 7          いくら        副詞    2
## 8    いつの間にか        副詞    1
## 9            いや      接続詞    3
## 10   いらっしゃる        動詞    2
## ...
## 365        落ちる        動詞    4
## 366   落ちる+ない 動詞+助動詞    1
## 367            葉        名詞    2
## 368            蓮        名詞    4
## 369          蓮池        名詞    4
## 370          蔽う        動詞    1
## 371            蕊        名詞    2
## 372            蛙        名詞    1
## 373          蜘蛛        名詞   14
## 374            蟻        名詞    1
## 375          蠢く        動詞    1
## 376            血        名詞    1
## 377        血の池        名詞    7

res  <- RCaBoChaFile("kumo.txt", "の")
res
 
##             Term         Pos Freq
## 1         あたり        名詞    3
## 2           あっ      感動詞    1
## 3           あの    フィラー    1
## 4           ある        動詞    9
## 5           ある      連体詞    3
## 6        ある+の   動詞+名詞    1
## 7        あれ+の   名詞+助詞    1
## 8         いくら        副詞    2
## 9   いつの間にか        副詞    1
## 10          いや      接続詞    3
## ... 

res  <- RCaBoChaFile("kumo.txt", rmT =c("記号","助詞") )
res

## 1          あたり        名詞    3
## 2            あっ      感動詞    1
## 3            あの    フィラー    1
## ...
## 399          違い        名詞    1
## 400     違い+ない 名詞+助動詞    1
## ...





res  <- RCaBoChaFile("kumo.txt", rmT =c("記号","助詞") , mecabrc="/Users/motohiro/.mecabrc")# mecabrc を指定





#####################################################
#
#
#          RCaBoChaDF() 関数
#
#
#####################################################
## データフレームから文書ターム行列を作成する。
## 
# RCaBoCha_0.25 までの rmT str2 は廃止しました

# 引数 pos =c("記号","助詞") などで抽出する品詞を指定できます
#　引数 minFreq で文書全体を通しての最小頻度を指定できます


dat <- read.csv("H18koe.csv")  ## 沖縄観光についての自由意見
res <- RCaBoChaDF(dat[,"opinion"])##やや時間がかかります
nrow(res)
 # [1] 2263
head(res[200:205, 1:5])
#          TERM        POS1        POS2 ROW3 ROW4
#200     どこ+店   名詞+名詞 代名詞+名詞    0    0
#201 どちら+下車   名詞+名詞 代名詞+名詞    0    0
#202     どれ+の   名詞+名詞 代名詞+名詞    0    0
#203   どれ+料理   名詞+名詞 代名詞+名詞    0    0
#204   どれ+沖縄   名詞+名詞 代名詞+名詞    0    0
#205   ない+こと 助動詞+名詞      *+名詞    0    0

res <- RCaBoChaDF(dat[,"opinion"], pos = c("名詞","形容詞","動詞"))###やや時間がかかります
nrow(res)

res <- RCaBoChaDF(dat[,"opinion"], pos = c("名詞","形容詞","動詞"), mecabrc = "/Users/motohiro/.mecabrc")



#####################################################
#
#
#          RCaBoChaMx() 関数
#
#
#####################################################
##　ファイルあるいはディレクトリから文書ターム行列を作成。

# RCaBoCha_0.25 までの rmT str2 は廃止しました

# 引数 pos =c("記号","助詞") などで抽出する品詞を指定できます
#　さらに引数 minFreq で文書全体を通しての最小頻度をしてできます

res <- RCaBoChaMx("morikita")
## file_name =  morikita/morikita1.txt opened
## file_name =  morikita/morikita2.txt opened
## file_name =  morikita/morikita3.txt opened

nrow(res)## [1] 66

res[50:55,]
#        TERM      POS1          POS2 morikita1.txt morikita2.txt
#50   科学+者 名詞+名詞     一般+名詞             0             0
#51     系+化 名詞+名詞     接尾+名詞             1             0
#52     系+特 名詞+名詞     接尾+名詞             1             0
#53 編曲+感じ 名詞+名詞 サ変接続+名詞             0             1
#54 編集+感じ 名詞+名詞 サ変接続+名詞             0             1
#55   者+企業 名詞+名詞     接尾+名詞             0             1
#   morikita3.txt
#50             1
#51             0
#52             0
#53             0
#54             0
#55             0


res <- RCaBoChaMx("morikita",pos = c("名詞","形容詞","動詞"))###やや時間がかかります
nrow(res)
#res <- RCaBoChaMx("morikita",pos = c("名詞","形容詞","動詞"), mecabrc = "/Users/motohiro/mecabrc")

#################################################################
#
#
#   RCaBoChaCnt() 関数
#
#
#################################################################
## 指定された単独ファイルを対象に，文の数，その文中の単語と品詞，文中の単語数，句数をまとめたデータフレームを返す．列名はそれぞれ
# totalNo = 文頭からの語数 
# SentNo  = 文番号 
# TermNo  = 文中単語番号 
# Term    = 単語 
# Pos     = 品詞 
# CharN   = その文字数 
# Cid     = 文中の句番号

res <- RCaBoChaCnt("kumo.txt" )
res[1:20,]

##    totalNo SentNo TermNo   Term    Pos CharN Cid
## 1        1      1      1   ある 連体詞     2   1
## 2        2      1      2     日   名詞     1   2
## 3        3      1      3     の   助詞     1   2
## 4        4      1      4     事   名詞     1   3
## 5        5      1      5     で 助動詞     1   3
## 6        6      1      6 ござい 助動詞     3   3
## 7        7      1      7   ます 助動詞     2   3
## 8        8      1      1     。   記号     1   1
## 9        9      2      1     御 接頭詞     1   1
## 10      10      2      2   釈迦   名詞     2   1
## 11      11      2      3     様   名詞     1   1
## 12      12      2      4     は   助詞     1   1
## 13      13      2      5   極楽   名詞     2   2
## 14      14      2      6     の   助詞     1   2
## 15      15      2      7   蓮池   名詞     2   3
## 16      16      2      8     の   助詞     1   3
## 17      17      2      9   ふち   名詞     2   4
## 18      18      2     10     を   助詞     1   4
## 19      19      2     11     、   記号     1   4
## 20      20      2     12   独り   名詞     2   5
## > 
