# Windows  なら R のメニューから[ファイル][スクリプトを開く]で RMeCab.R を開く
# MacOS X  ならR のメニューから[ファイル][文書の読み込み]で RMeCab.R を開く
#
################## 「RMeCabの操作方法」
# 

######## パッケージの読み込み
# library(RMeCab)
# 上の一行の代わりに Windows では
# メニューの [パッケージ] - [パッケージの読み込み] でもよい

# 必要なら作業ディレクトリを指定
# setwd("C:/data") # Windows
# setwd("/Users/*YourAccount*/data") # MacOS X/Linux

###########################################
#　テスト 1 # RMeCabC () 関数 # 入力文の解析

kekka <- RMeCabC("すもももももももものうち")
unlist(kekka)

# こんな結果
#    名詞     助詞     名詞     助詞     名詞     助詞     名詞 
#"すもも"     "も"   "もも"     "も"   "もも"     "の"   "うち" 


###########################################
#　テスト 2 # RMeCabC () 関数 
# 第二引数 1 を加えると形態素原型を返します．

kekka <- RMeCabC("ご飯を食べた",1)
unlist(kekka)

#    名詞     助詞     動詞   助動詞 
#  "ご飯"     "を" "食べる"     "た" 
#
#　第二引数を加えない場合
#

kekka <- RMeCabC("ご飯を食べた")
unlist(kekka)

#    名詞     助詞     動詞   助動詞


###########################################
#　テスト 3 # RMeCabC () 関数
# 上記の結果から名詞だけ取り出したければ

unlist(kekka) [names(unlist(kekka)) == "名詞"]

# ご飯

###########################################
# テスト4 # RMeCabC () 関数 # 少し長い文章 (120 文字) を解析

kekka <- RMeCabC("皇居のお堀を淡いピンクで染めるソメイヨシノの並木は、仕事帰りのOLやサラリーマンに人気のお花見スポット。昼はボートに乗ってお花見を楽しめ、夜はライトアップされロマンチックな雰囲気だ。緑道から眺める石垣と可憐な桜の対比がなんともいえず美しい。")

unlist(kekka)



###########################################
#　テスト5 # RMeCabText()関数 # 引数で指定されたファイルを解析し，結果をそのまま表示する
#　ホームディレクトリに、添付の data フォルダを丸ごとコピーしてから

# targetText <- "C:/data/yukiguni.txt"
# targetText <- "/Users/*YourAccount*/data/yukiguni.txt"
targetText <- "yukiguni.txt"
kekka <- RMeCabText( targetText  )
kekka

# こんな結果
## 		 [[1]]
## 		  [1] "国境"       "名詞"       "一般"       "*"          "*"
## 		  [6] "*"          "*"          "国境"       "コッキョウ" "コッキョー"
## 		 [[2]]
## 		  [1] "の"     "助詞"   "格助詞" "一般"   "*"      "*"      "*"      "の"
## 		  [9] "ノ"     "ノ"
## 		 [[3]]
## 		  [1] "長い"             "形容詞"           "自立"             "*"
## 		  [5] "*"                "形容詞・アウオ段" "基本形"           "長い"         
## 		 # ... 以下略    

## ###########################################
#　テスト 6 #　RMeCabFreq()関数 # ファイルから頻度表を作成 
# targetText <- "C:/data/yukiguni.txt"
# targetText <- "/Users/*YourAccount*/data/yukiguni.txt"
targetText <- "yukiguni.txt"
kekka <- RMeCabFreq(  targetText  )
kekka

# こんな結果
## length = 23 
##        Term  Info1    Info2 Freq
## 1      ある 助動詞        *    1
## 2        た 助動詞        *    3
## 3        だ 助動詞        *    1
## 4        と   助詞 接続助詞    1
## 5        が   助詞   格助詞    2
## 6        に   助詞   格助詞    1
## 7        の   助詞   格助詞    1
## 8        を   助詞   格助詞    1
## 9        の   助詞   連体化    1
## 10     なる   動詞     自立    1
## 11   抜ける   動詞     自立    1
## 12   止まる   動詞     自立    1
## 13 トンネル   名詞     一般    1
## 14     信号   名詞     一般    1
## 15     国境   名詞     一般    1
## 16       底   名詞     一般    1
## 17     汽車   名詞     一般    1
## 18     雪国   名詞     一般    1
## 19       夜   名詞 副詞可能    1
## 20       所   名詞     接尾    1
## 21     白い 形容詞     自立    1
## 22     長い 形容詞     自立    1
## 23       。   記号     句点    3
## > 

###########################################
#　テスト 7 ## ちょっと時間がかかります
#        芥川龍之介　『蜘蛛の糸』(青空文庫から借用)
#        ただし主人公の名前の「かん陀多」の
#        「かん」にあたる漢字は特殊文字なので削っている

#　実行時間を計る
# targetText <- "C:/data/kumo.txt"
# targetText <- "/Users/*YourAccount*/data/kumo.txt"
targetText <- "kumo.txt"

pt1 <- proc.time()
kekka <- RMeCabFreq(targetText )
pt2 <- proc.time()

#　実行時間を見る

pt2 - pt1

# 解析結果を見る

kekka


# 頻度表をグラフにしてみる
# 『蜘蛛の糸』から、一般名詞かつ頻度が　７　以上の語を選ぶ

kekka <- kekka [kekka[, 2] == "名詞" & kekka[, 3] == "一般" & kekka[,4] > 6, ] 

matplot(1:length(kekka$Term), kekka[,4], type = "n")
for(i in 1:length(kekka$Term)){
	matlines(i, kekka[i,4], type = "h", col = i, lwd =5)
}
legend(1, max(kekka$Freq), legend = kekka$Term, col = 1:15, lwd = 5)


# なお　Windows　版の MeCab辞書　では「なんとも云えない」を
############
# #  なんとも        副詞,一般,*,*,*,*,なんとも,ナントモ,ナントモ
# # 云      名詞,一般,*,*,*,*,云,ウン,ウン
# # え      フィラー,*,*,*,*,*,え,エ,エ
# # ない    形容詞,自立,*,*,形容詞・アウオ段,基本形,ない,ナイ,ナイ
############
# のように「え」を「フィラー」とみなしてしまうようです
# 別途辞書をコンパイルする必要があるMac/Linuxでは「云え」動詞と
# 正しく解析します

#########  辞書の作成方法は石田基広著「Rによる日本語テキストマイニング」(仮題)か
### http://mecab.sourceforge.net/dic.html を参照されたい


### 太宰治　『走れメロス』# 青空文庫から転用
# targetText <- "C:/data/merosu.txt"
# targetText <- "/Users/*YourAccount*/data/merosu.txt"
targetText <- "merosu.txt"

pt1 <- proc.time()
kekka <- RMeCabFreq( targetText )
pt2 <- proc.time()

#　実行時間を見る

pt2 - pt1

# 解析結果は長いので、名詞の一部だけを見る

kekka[kekka$Info1 == "名詞" & kekka$Info2 == "一般", ]
# こんな結果
##                  Term Info1 Info2 Freq
## 627            あたり  名詞  一般    1
## 628              あて  名詞  一般    1
## 629                い  名詞  一般    1
## 630            いちど  名詞  一般    1
## 631            いのち  名詞  一般    3



###########################################
#　テスト 8 ## * RMeCabDF()関数 # データフレームの指定列を解析 
# targetText <- "C:/data/photo.csv"
# targetText <- "/Users/*YourAccount*/data/photo.csv"
targetText <- "photo.csv"

dat <- read.csv(targetText, head = T)

# 男性の被験者だけを見る
dat[dat$Sex == "M",]

# datという読み込んだデータの 3 列目に日本語がある
# とすると， 3 列目のデータをすべて形態素解析にかけます．

RMeCabDF(dat, 3)

## こんな結果
# [[1]]
#  名詞   動詞   助詞   動詞   助詞 
# "写真" "撮っ"   "て" "くれ"   "よ" 
#
# [[2]]
#      名詞       動詞       助詞       動詞 
#    "写真"     "とっ"       "て" "ください" 
# また

RMeCabDF(dat, 3, 1)

# とすると，形態素原型を返します．


###########################################
#　テスト 9 # docMatrix() 関数 # 文書ターム行列の作成
# 抽出する品詞はpos引数で指定できる

#　Cドライブに添付の data フォルダを丸ごとコピーしてから
# targetDir <- "C:/data/doc"
# targetDir <- "/Users/*YourAccount*/data/doc"
targetDir <- "doc"

res <- docMatrix(targetDir, pos = c("名詞","形容詞","助詞"))
## Reading file doc/doc1.txt
## Reading file doc/doc2.txt
## Reading file doc/doc3.txt
# こんな結果
##                   docs
## terms              doc1.txt doc2.txt doc3.txt
##   [[LESS-THAN-1]]         0        0        0
##   [[TOTAL-TOKENS]]        4        6        8
##   は                      1        1        1
##   学生                    1        1        0
##   私                      1        0        0
##   の                      0        1        0
##   数学                    0        1        1
##   彼女                    0        1        1
##   で                      0        0        1
##   を                      0        0        1

###########################################
#　テスト 10 ## 文書ターム行列の作成　重みをつける
# 抽出する品詞はpos引数で指定できる

kekka <- docMatrix(targetDir, pos = c("名詞","形容詞"), minFreq = 1, weight = "tf*idf") 
kekka
# こんな結果
## Reading file doc/doc1.txt
## Reading file doc/doc2.txt
## Reading file doc/doc3.txt
##       docs
## terms  doc1.txt doc2.txt doc3.txt
##   学生 1.584963 1.584963 0.000000
##   私   2.584963 0.000000 0.000000
##   数学 0.000000 1.584963 1.584963
##   彼女 0.000000 1.584963 1.584963

###########################################
#　テスト 11 ## 文書ターム行列の作成　重みをつける 

kekka <- docMatrix(targetDir, pos = c("名詞","形容詞"),  weight = "tf*idf*norm")
kekka
# こんな結果
## Reading file doc/doc1.txt
## Reading file doc/doc2.txt
## Reading file doc/doc3.txt
##       docs
## terms   doc1.txt  doc2.txt  doc3.txt
##   学生 0.5227132 0.5773503 0.0000000
##   私   0.8525086 0.0000000 0.0000000
##   数学 0.0000000 0.5773503 0.7071068
##   彼女 0.0000000 0.5773503 0.7071068



###########################################
#　テスト 12  # Ngram()関数  :引数で指定されたファイルについて，
# N-gram を計る．引数 type が 0 なら文字単位で，1 なら形態素原形を単位として，
# また 2 なら品詞情報を単位に N-gram をカウントする．なお N は引数 N で指定．
# targetText <- "/Users/*YourAccount*/data/doc"
# targetText <- "C:/data/doc"
targetText <- "kumo.txt"
kekka <- Ngram(targetText, type = 0, N = 2)
nrow(kekka)
kekka[1:100,]


## # こんな結果
##       Ngram Freq
## 1   [、-「]    3
## 2   [、-あ]    1
## 3   [、-い]    4
## 4   [、-う]    2
## 5   [、-き]    2

kekka <- Ngram(targetText, type = 1, N = 3)
nrow(kekka)
kekka[1:100,]

# こんな結果
##                    Ngram Freq
## 1           [、-「-いや]    1
## 2           [、-「-こら]    1
## 3         [、-「-しめる]    1
## 4           [、-ある-時]    1
## 5         [、-いくら-何]    1

kekka <- Ngram( targetText, type = 2, N = 3)
nrow(kekka)
kekka[1:100,]

# こんな結果
##                      Ngram Freq
## 1     [フィラー-副詞-動詞]    1
## 2         [副詞-副詞-動詞]    1
## 3         [副詞-副詞-名詞]    1
## 4         [副詞-助詞-動詞]    4
## 5         [副詞-助詞-名詞]    2


# 形態素 type = 2 を指定した場合は，品詞を指定して N-gram を抽出することができる．
res <- Ngram("yukiguni.txt", type = 1, N = 2, pos = "名詞")
res
# こんな結果
## 		             Ngram Freq
## 		 1 [トンネル-雪国]    1
## 		 2       [信号-所]    1
## 		 3 [国境-トンネル]    1
## 		 4         [夜-底]    1
## 		 5       [底-信号]    1
## 		 6       [所-汽車]    1
## 		 7       [雪国-夜]    1

###########################################
#　テスト 13  # Ngram()関数  :引数で指定されたファイルについて，
# N-gram を計る．ただし出力はN-gramの要素ごとに列を分けたデータフレーム
kekkaDF <- NgramDF("yukiguni.txt", type = 1, N = 2,   pos = "名詞")
kekkaDF
## # こんな結果
## 		     Ngram1   Ngram2 Freq
## 		 1 トンネル     雪国    1
## 		 2     信号       所    1
## 		 3     国境 トンネル    1
## 		 4       夜       底    1
## 		 5       底     信号    1
## 		 6       所     汽車    1
## 		 7     雪国       夜    1


###########################################
#　テスト 14  #  docNgram()関数  :引数で指定したフォルダを指定し，そのフォルダ内のすべてのファイルを解析対象としてターム・文書行列を作成するなお，この関数でも引数 \verb|type| と \verb|N| を \verb|Ngram()| 関数の場合と同じように指定することができる．以下では \verb|data| フォルダ内にある \verb|doc| フォルダに含まれた全ファイルを対象に解析する．

res <- docNgram("doc")
nrow(res)
#		 [1] 16
 res
## # こんな結果

## 		          Text
## 		 Ngram     doc1.txt doc2.txt doc3.txt
## 		   [い-ま]        0        0        1
## 		   [で-い]        0        0        1
## 		   [の-学]        0        1        0
## 		# 以下略


###########################################
#　テスト 15  # collocate()関数  : 指定されたファイルについて，
# word で指定された語(ただし形態素原形)の前後に出てくる単語頻度を計算する．
# なおスパンは引数 span で指定する．
kekka <- collocate(file = targetText, node = "極楽", span = 3)
 # length = 31
kekka

## # こんな結果

##            Term Span Total
## 1            、    2   136
## 2            。    4    61
## 3            う    1     9
## 4            が    1    34
## 5          この    1    11
## 6        しかし    2     2


###########################################
#　テスト 16  # colloScores()関数
# collocate() 関数の出力であるオブジェクト を第 1 引数として，collocate() 関数で指定した中心語を node 引数に，同じく span に前後の語数を指定する．
res2 <- collScores(kekka, node = "極楽", span = 3)

 res2
## ## # こんな結果
##            Term Span Total          T         MI
## 1            、    2   136 -1.7771533 -1.1741745
## 2            。    4    61  0.9878319  0.9825510
## 3            う    1     9  0.7013274  1.7433634
## 4            が    1    34 -0.1283186 -0.1741745
## 5          この    1    11  0.6349558  1.4538567
